/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// Shader Created by Phil Lira - felipedrl@gmail.com

    // Inputs - Play with these values.
    const int   steps = 100;
    const float scale = 2.5;
    const vec2  pan = vec2(0.6, 0.5);
    const float animationFactor = 8.0;
    const float minN = 1.0;
    const float maxN = 4.0;
    ////////////////////////////////

void main(void)
 {
   vec2 c = gl_FragCoord.xy / iResolution.xy;

   // map from [0,1] to [-0.5,0.5] then apply pan and scale.

   c = ( c - pan ) * scale;

   // apply aspect ratio to fix distortion

   c.x *= iResolution.x / iResolution.y;

   int currStep = 0;

   // modelling complex number with vec2 z = x + yi. Should start
   // with z = 0, but that leads to numerical difficulties on the
   // first iteration because atan(0,0) is not well defined. So I
   // have used a very cheap solution. TheEmu.

   vec2 z = vec2(0.000000000001);

   float alpha = abs ( sin(iGlobalTime/animationFactor) );
   float n = minN + alpha * ( maxN - minN );

   for ( int i = 0; i < steps; i++ )
    {
      // General formula of Z -> pow(Z,n) + C

      float x2 = z.x * z.x;
      float y2 = z.y * z.y;

      float powX2Y2 = pow ( x2+y2, n*0.5 );
      float atanN = n * atan ( z.y, z.x );

      float x = powX2Y2 * cos(atanN) + c.x;
      float y = powX2Y2 * sin(atanN) + c.y;

      if ( (x*x + y*y) > 4.0 ) break;

      z.x = x;
      z.y = y;

      currStep++;
 
    }

   float color = float(currStep) / float(steps);
   float r = (currStep < steps) ? color * color : 0.0;

   gl_FragColor = vec4 ( log(r*15.0) / log(n), color, color, 1.0 );

 }